#ifndef __CLOUD_H
#define __CLOUD_H

enum cloudtype {NONE, THUNDER, RAIN};

const int PIXELPERIT = 2;
const int MARGIN = 0;
const int SCALE = 200;

class Comm;

struct pos{
	float x, y;
	pos() {
		x = 0.0F;
		y = 0.0F;
	}
};

class Cloud {
private:
	Cloud* next;
	pos position;
	pos velocity;
	float vapour;
	float speed;
	int points;
	cloudtype type;
public:
	Cloud();
	Cloud(char* line, cloudtype tp);

	void set_next(Cloud* cl);
	Cloud* get_next();
	float get_vapour();
	void cal_points(Cloud* me);
	void next_move(Comm* c, Cloud* me);
	int get_points();
	int get_speed();
	
//DEBUG FUNCTIONS
	void display();
};

#endif